@extends('partials.main')
@section('title')
    {{ 'Map' }}
@endsection
@section('content')
    <style>
        .alert-success {
            color: #3c763d;
            background-color: #dff0d8;
            border-color: #d6e9c6;
            padding: 20px;
        }

        .btn {
            margin-bottom: 5px;

        }

        .alert-success {
            color: #0e0e0e;
            background-color: #fee133;
            border-color: #d6e9c6;

            text-align: center;
        }

        #dist {
            background-color: black !important;
            color: white;
            text-align: center;
        }

        .mapset {
            border: 2px solid #000;
            padding: 20px;
            margin-bottom: 15px;
        }

        .modal-backdrop {
            position: inherit;
            top: 0;
            right: 0;
            bottom: 0;
            left: 0;
            z-index: 1040;
            background-color: #000;
        }
    </style>
    <!--************************************
                                                                                                                                                                                          Inner Banner Start
                                                                                                                                                                                        *************************************-->
    <section class="tg-parallax tg-innerbanner" data-appear-top-offset="600" data-parallax="scroll"
        data-image-src="../images/Home/pexels-shaani-sewwandi-2937148.jpg">
        <div class="tg-sectionspace tg-haslayout">
            <div class="container">
                <div class="row">
                    <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                        <h1>MAPS DISTANCE</h1>
                        <h2>Start your adventure today with Lanka Getaways!"</h2>
                        <ol class="tg-breadcrumb">
                            <li><a href="javascript:void(0);">Home</a></li>
                            <li class="tg-active">MAPS DISTANCE</li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--************************************
                                                                                                                                                                                          Inner Banner End
                                                                                                                                                                                        *************************************-->
    <!--************************************
                                                                                                                                                                                          Main Start
                                                                                                                                                                                        *************************************-->
    <main id="tg-main bg-map" class="tg-main tg-sectionspace tg-haslayout ">
        <div class="container">
            <div class="row">
                <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                    <div id="tg-content" class="tg-content">

                        <div class="mapset row">
                            <div class="col-xs-12 col-sm-6 col-md-8 col-lg-8">
                                <h1>MAPS DISTANCE</h1>
                                <p>Let's Plan Your Next Trip Together</p>
                                <form class="form-horizontal">
                                    <!-- Origin input with autocomplete -->
                                    <div class="form-group">
                                        <label for="origin" class="col-xs-2 control-label">
                                            <i class="far fa-dot-circle"></i>
                                        </label>
                                        <div class="col-xs-10">
                                            <input type="text" id="origin" placeholder="Origin"
                                                class="form-control" />
                                        </div>
                                    </div>
                                    <!-- Destination inputs (dynamically added) -->
                                </form>
                                <div style="margin-bottom: 10px;" class="col-xs-offset-2 col-xs-10 ">
                                    <button class="btn btn-primary" onclick="addDestinationInput();">
                                        Add Destination
                                    </button>

                                    <button class="btn btn-success " onclick="calculateDistance();">
                                        <i class="fa fa-arrow-circle-o-right" aria-hidden="true"></i>
                                        Calculate Distance
                                    </button>

                                </div>
                            </div>
                            <div class="col-xs-12 col-sm-6 col-md-4 col-lg-4">
                                <div id="output"></div>
                                <div class="discard">
                                    <div>
                                        <div id="distances">

                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>


                        <div class="container-fluid">
                            <div id="googleMap" style="width: 100%; height: 400px"></div>

                        </div>
                    </div>
                </div>
            </div>
        </div>



        <div class="modal " id="testmodel" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
            aria-hidden="true">
            <form id="inquiry" action="" method="POST">

                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalLabel">PLACE INQUIRY FOR THIS TOUR</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">

                            <div>
                                <input type="hidden" id="places" name="places">


                                <label>Name <sup>*</sup></label>
                                <input type="text" name="name" class="form-control" placeholder="">





                                <label>Phone <sup>*</sup></label>
                                <input type="text" name="phone" class="form-control" placeholder="">
                                <label>Email <sup>*</sup></label>
                                <input type="text" name="email" class="form-control" placeholder="">






                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                            <button id="in-submit" type="submit" class="btn btn-primary">Save changes</button>
                        </div>
                    </div>
                </div>
            </form>
        </div>

    </main>


    <script>
        $(document).ready(function() {
            $('#in-submit').click(function(event) {
                event.preventDefault();
                var formData = $('#inquiry').serialize();
                console.log(formData);
                $.ajax({
                    url: '/submit-inquiry',
                    method: 'POST',
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    data: formData,

                });
            });
        });
    </script>


    <script src="https://maps.googleapis.com/maps/api/js?libraries=places&key=AIzaSyDql98PYRkfw52KazQjeaGgB6C3ZEaHR_4">
    </script>
    <!--************************************
                                                                                                                                                                                          Main End
                                                                                                                                                                                        *************************************-->
@endsection
